<?php
/**
 * Plugin Name: NextGEN Gallery Alphabetize Add Gallery Dropdown
 * Description: Alphabetizes the gallery dropdown on the Add Gallery page (admin.php?page=ngg_addgallery) without modifying NextGEN Gallery directly.
 * Version: 1.0.0
 * Author: universityofstuff
 * License: GPL-2.0-or-later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Requires at least: 5.0
 * Tested up to: 6.8
 */

if (!defined('ABSPATH')) {
    exit; // Prevent direct access
}

/**
 * Inject sorting JS ONLY on the NGG Add Gallery page.
 */
function ngaag_sort_gallery_dropdown_script() {

    // Security: validate input **without causing nonce errors**
    $page = filter_input(INPUT_GET, 'page', FILTER_SANITIZE_STRING);

    // Only insert on the correct admin page
    if ($page !== 'ngg_addgallery') {
        return;
    }

    ?>
    <script>
    document.addEventListener("DOMContentLoaded", function () {
        let select = document.getElementById("gallery_id");
        if (!select) return;

        // Keep first option
        let first = select.options[0];
        let options = Array.from(select.options).slice(1);

        // Alphabetize
        options.sort(function(a, b) {
            return a.text.trim().localeCompare(b.text.trim(), undefined, { sensitivity: 'base' });
        });

        // Replace options
        select.innerHTML = '';
        select.appendChild(first);
        options.forEach(o => select.appendChild(o));
    });
    </script>
    <?php
}
add_action('admin_footer', 'ngaag_sort_gallery_dropdown_script');
